<?php
session_start();
require_once 'app/Controllers/AuthController.php'; 

$authController = new AuthController();
$errors = [];

// Si l'utilisateur est déjà connecté, le rediriger vers le tableau de bord
if (isset($_SESSION['user_id'])) {
    header('Location: dashboard.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $displayName = trim($_POST['display_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $passwordConfirm = $_POST['password_confirmation'] ?? '';

    $result = $authController->register($displayName, $email, $password, $passwordConfirm);

    if ($result['success']) {
        $_SESSION['registration_success_message'] = "Compte créé avec succès. Vous pouvez maintenant vous connecter.";
        header('Location: identification.php');
        exit();
    } else {
        $errors = $result['errors'];
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nouvel Acte - Inscription</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="auth-page">
    <div class="auth-background">
        <!-- Logo -->
        <div class="logo">
            <a href="index.html">
                <div class="logo-icon"></div>
                <div class="logo-text">Nouvel Acte</div>
            </a>
        </div>

        <!-- Formulaire d'inscription -->
        <div class="auth-card">
            <h1>Créez votre compte</h1>
            
            <?php if (!empty($errors)): ?>
                <?php foreach ($errors as $error): ?>
                    <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
                <?php endforeach; ?>
            <?php endif; ?>
            
            <form method="POST" action="register.php" id="registerForm">
                <input type="text" name="display_name" placeholder="Nom d'affichage" required value="<?php echo htmlspecialchars($_POST['display_name'] ?? ''); ?>">
                <input type="email" name="email" placeholder="E-mail" required value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
                <input type="password" name="password" placeholder="Mot de passe (min. 8 caractères)" required>
                <input type="password" name="password_confirmation" placeholder="Confirmer le mot de passe" required>
                <button type="submit">S'inscrire</button>
            </form>
            
            <div class="auth-links">
                <a href="identification.php">Déjà un compte ? Se connecter</a>
            </div>
        </div>
    </div>
    <script src="assets/js/main.js"></script>
</body>
</html>
